/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.components;

import java.util.HashMap;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;

public interface IItemBlock {
    public static final Map<IItemBlock, ABlockBase> itemToBlockMap = new HashMap<IItemBlock, ABlockBase>();

    public Class<? extends ABlockBase> getBlockClass();

    public ABlockBase createBlock();

    default public ABlockBase getBlock() {
        if (!itemToBlockMap.containsKey(this)) {
            Class<? extends ABlockBase> blockClass = this.getBlockClass();
            ABlockBase existingBlock = null;
            if (blockClass != null) {
                for (ABlockBase block : itemToBlockMap.values()) {
                    if (!blockClass.equals(block.getClass())) continue;
                    existingBlock = block;
                    break;
                }
            }
            if (existingBlock != null) {
                itemToBlockMap.put(this, existingBlock);
            } else {
                try {
                    itemToBlockMap.put(this, this.createBlock());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return itemToBlockMap.get(this);
    }

    default public boolean placeBlock(AWrapperWorld world, IWrapperPlayer player, Point3D position, ABlockBase.Axis axis) {
        return world.setBlock(this.getBlock(), position, player, axis);
    }
}

